; OverlayInfoMux Alpha 0.4
; simplify: MOV		R0, SP, ADD		R0, #sp_refresh_buffer

; developing on Siemens m65v50
; (c) benj9

					AREA benj9, CODE, READONLY  

					IMPORT	mp_Bufferizer
					IMPORT	f092_GetCPUClock
					IMPORT	f093_GetCPULoad
					IMPORT	v02_RamNetCH
					IMPORT	v03_RamNetRX
					IMPORT	f160_Uncicode_sprintf
					IMPORT	f161_Unicode_CopyStr2Str
					IMPORT	f162_Unicode_GetCharByPosition
					IMPORT	f077_CallAfterTimer
					IMPORT	f063_SelectColor
					IMPORT	f081_GetNetMode
					IMPORT	f035_DrawImg
					IMPORT	f036_DrawImage2
					IMPORT	f037_DrawCanvas
					IMPORT	f038_DrawImageBW
					IMPORT	v19_ram_mainscreen_accu_icon
				
					EXPORT	e_refresh
					EXPORT	e_screen

; masterpatch midlet generel
mp_g_LoadPercent	EQU	3	;b
mp_g_RefreshTime	EQU	4	;w

; masterpatch midlet style record (lenght 0xC0), relative offset

mp_s_mode			EQU	0
mp_s_font			EQU	1
mp_s_alignement		EQU	2
mp_s_overlay		EQU	3
mp_s_x0				EQU	4
mp_s_y0				EQU	5
mp_s_x1				EQU	6
mp_s_y1				EQU	7
mp_s_fg_col			EQU	8
mp_s_bg_col			EQU	12
mp_s_shift_table	EQU	16 ; potential 16 functions 
mp_s_format			EQU	32 ; format string length, size 160 bytes


					DCB		"OvlayMx03,benj9",0
					
					CODE16
					ENTRY	

; =====================================================================


e_screen			LDR		R0, mp_id
					BL		mp_Bufferizer							
					BNE		screen_mp_yes
					
screen_mp_no		ADR		R6, style_nopatch
					B		screen_do
					
screen_mp_yes		ADD		R6, #0x10 ; use mainscreen style
					

screen_do			ADD     R0, SP, #0x2C
					
				    LDRB	R2, [R6,#mp_s_y1] ; [R4,#4]
					STR     R2, [SP]
					
					LDRB    R3, [R6,#mp_s_x1];  [R4] 
					
					LDRB	R2, [R6,#mp_s_y0] ; 0
					LDRB	R1, [R6,#mp_s_x0] ; 0

					LDR		R7, ScreenWindow_Metrics ; R0=buf, R1=x, R2=y, R3=width,[SP]=height
					BLX		R7						

 					LDRB	R2, [R6,#mp_s_alignement] ; 0 ;  alignement, 0=left 2=center, 4=right
					STR     R2, [SP,#4]
					
					LDRB    R1, [R6,#mp_s_font]
					STR     R1, [SP]

					MOV     R3, R5 ; wstring
					LDRB	R2, [R6,#mp_s_overlay] ; 0
					ADD     R1, SP, #0x2C
					ADD     R0, SP, #8
					LDR		R7, ScreenWindow_Text ;R0=buffer, R1=points2 general_metrics, R2=inversion?, r3=ptr2ws, SP=font, sp+4=alignement?
					BLX		R7
	
					ADD		R0, SP, #8
					MOV		R1, R6
					ADD		R1, #mp_s_fg_col
					ADD		R2, R1, #4 ; = R6 + #mp_s_bg_col]

					LDR		R7, ScreenWindow_Color
					BLX		R7
					
screen_x			LDR		R7, Screen_OverlayDisplay_return
					BX		R7	
										
; =============================================================
			
sp_refresh_size		EQU		0x100
sp_refresh_shift	EQU		8

num_of_funcs		EQU		10


sp_refresh_param	EQU		0
sp_refresh_cpuload	EQU		(num_of_funcs - 2) * 4 
sp_refresh_cpuclock	EQU		sp_refresh_cpuload + 4 

sp_refresh_timer	EQU		sp_refresh_cpuclock + 4 
sp_refresh_buffer	EQU		sp_refresh_timer + 4  


		
e_refresh			PUSH	{R1-R3, R6} ; delete 1-3
					MOV		R4, R0
					SUB		SP ,#sp_refresh_size ; space
					
					STR		R5, [SP, #sp_refresh_timer]
					LDR		R0, mp_id
					BL		mp_Bufferizer							
					BEQ		refresh_nopatch

					BL		f093_GetCPULoad
					STR		R0, [SP, #sp_refresh_cpuload]
					
					BL		f092_GetCPUClock
					STR		R0, [SP, #sp_refresh_cpuclock]
					
					STR		R5, [SP, #sp_refresh_timer]

					; which config style?
					
					; --- build sprintf argument table ---------
					
refresh_prep_str	SUB		SP, #sp_refresh_shift ; sp=dest ; cheat in r2, r3 in stack transition concept
					
					MOV		R4, R6
					ADD		R4, #0x10+mp_s_shift_table ; r4=src  ####adapt for multi style###
					MOV		R5, #0 ; counter
					
refresh_prep_str_L	LDRB	R7, [R4, R5]
					;MOV		R0,R7
					;B refresh_prep_str_2


					CMP		R7, #num_of_funcs
					BLT		refresh_prep_str_L1
					
					B		refresh_prep_off
					
					;LSL		R7, #1
					;SUB		R6, #2
					;ADD
					
refresh_prep_str_L1	CMP		R7, #0
					BEQ		refresh_prep_off
					
					CMP		R7, #1
					BEQ		_get_cpu_load
					
					CMP		R7, #2
					BEQ		_get_cpu_clock
					
					CMP		R7, #3
					BEQ		_get_net_rx
					
					CMP		R7, #4
					BEQ		_get_net_mode
					
					CMP		R7, #5
					BEQ		_get_byte_1 
					
					CMP		R7, #6
					BEQ		_get_byte_2
					
					CMP		R7, #7
					BEQ		_get_dword
						
					CMP		R7, #8
					BEQ		_get_string	
					
refresh_prep_off	MOV		R0, #0	
					
refresh_prep_str_2	LSL		R1, R5, #2
					MOV		R2, SP
					STR		R0, [R2, R1]
					
					ADD		R5, #1
					CMP		R5, #num_of_funcs
					BLT		refresh_prep_str_L
					
					LDR		R2, [SP]
					LDR		R3, [SP, #4]
					
					ADD		SP, #sp_refresh_shift 
										
					; ----------------------------------
					
refresh_string		MOV		R0, SP
					ADD		R0, #sp_refresh_buffer
					ADD		R1, R0, #4
					STR		R1, [R0]

					MOV		R1, R6
					ADD		R1, #mp_s_format
					ADD		R1, #0x10
					BL		f160_Uncicode_sprintf
										
					MOV		R4, SP
					ADD		R4, #sp_refresh_buffer

					B		refresh_disp_out
								
refresh_disp_null	LDR		R1,[R4]
					MOV		R2,#0
					STRH	R2,[R1]
					MOV		R0, R4
					B		refresh_disp_out
					
refresh_nopatch		MOV		R0, R4
					LDR		R7, DevMenOverlayDisp_functions
					BLX		R7
								
refresh_disp_out	MOV		R0, R4
					LDR		R7, DevMenOverlayDisp_outbuf_prep
					BLX		R7

					LDR     R7, DevMenOverlayDisp_RefreshScreen
					BLX		R7

refresh_time		CMP		R6, #0 ; nopatch?
					BEQ		refresh_time_def	
					
					LDR		R1, [R6,#mp_g_RefreshTime] 
					CMP		R1, #8 ; prevent overload
					BGE		refresh_do
					
					MOV		R1, #8
					B		refresh_do
					
refresh_time_def	MOV		R1, #0xA0 ; default cycle time nopatch	

refresh_do			LDR		R0, [SP, #sp_refresh_timer]
					LDR		R2, DevMenOverlayDisp
					BL		f077_CallAfterTimer
										
					ADD		SP,#sp_refresh_size ; string space
					POP		{R1-R3, R6}
					ADD     SP, #0x78 
				    POP     {R4,R5,R7,PC}
				
; =============================================================				
				
_get_cpu_load		LDR		R0, [SP, #(sp_refresh_shift + sp_refresh_cpuload)]
					B		refresh_prep_str_2
					
; ---------------------------------------------------------------------

_get_cpu_clock		LDR		R0, [SP, #(sp_refresh_shift + sp_refresh_cpuclock)]
					B		refresh_prep_str_2
					
; ---------------------------------------------------------------------
					
_get_net_rx			BL		v03_RamNetRX
					LDRB	R0,[R7]
					; MOV		R0,#0
					B		refresh_prep_str_2
		
; ---------------------------------------------------------------------
					
_get_net_mode		BL		f081_GetNetMode

					B		refresh_prep_str_2
					
; ---------------------------------------------------------------------
					
_get_byte_1			LDR		R7, ram_netmode_2
					LDRB	R0,[R7]

					B		refresh_prep_str_2


; ---------------------------------------------------------------------
					
_get_byte_2			LDR		R7, ram_funnybyte
					LDRB	R0,[R7]

					B		refresh_prep_str_2
					
; ---------------------------------------------------------------------
					
_get_dword			LDR		R7, Ram_Timer975_inc
					LDR		R0,[R7]

					B		refresh_prep_str_2
					
; ---------------------------------------------------------------------
					
_get_string			ADR		R0, mystring

					B		refresh_prep_str_2
; ---------------------------------------------------------------------
				

; =====================================================================



DevMenOverlayDisp					DCD	0xA08C8957

DevMenOverlayDisp_functions			DCD	0xA08C89B7
DevMenOverlayDisp_outbuf_prep		DCD	0xA1149673
DevMenOverlayDisp_RefreshScreen		DCD	0xA1149701

ScreenWindow_Metrics				DCD	0xA114A30C+1
ScreenWindow_Text					DCD	0xA116647C+1
ScreenWindow_Color					DCD	0xA1163C5A+1
; ScreenWindowPushBuffer_f			DCD	0xA11496B5
ScreenWindowPushBuffer				DCD	0xA11496E0+1
;ScreenWindowReleaseBuffer			DCD	0xA1146414+1

Screen_OverlayDisplay_return		DCD	0xA114640B


ram_increasing_number				DCD 0xA8001748
ram_serial_armdebugger_packets		DCD 0xA8739EF4
Ram_Timer975_inc					DCD 0xA8717FFC         
ram_netmode_2						DCD	0xA8752560
ram_accupoint						DCD 0xA86B4144
ram_funnybyte						DCD	0xA8638E1C

mp_id								DCD	0xCCCB	
col_fg								DCB	0,0,0xFF,0x55	
col_bg								DCB	0,0,0x2C,0x48	

;format1								DCB "tk %d, cpu %03d net2: %02X , rx: %d - so, der text kommt noch langbla bla bla",0
format1								DCB "tk %05d, cpu %03d net2: %02X , rx: %02d",0



 ALIGN
style_nopatch						DCB	1,4,4,0,0,0,132,176 ; mode,font,alignenemt,ovl,xy0,xy1
									DCB	0xFF,0xFF,0xFF,100, 0,0,0,100 ; colors
									; void shift_table & string 
									
; style_funky							DCB	1,1,0,0,0,34,132,30 ; mode,font,alignenemt,ovl,xy0,xy1
									DCB	0xFF,0,0,100, 0,0,240,80 ; colors
									; void shift_table & string 
								
mystring							dcb "hello",0

;_mywstring							DCD	mywstring
;mywstring							DCB 05,00,"b",0,"e",0,"n",0,"j",0,"9",0
					END

; =============================================================

mytest				PUSH	{R1-R7,LR}
					SUB		SP, #0x180		

					
					MOV		R0, #50
					STR		R0,[SP]
					MOV		R3, #110
					MOV		R2, #35
					MOV		R1,#10
					
					ADD     R0, SP, #0x10					
					LDR		R7, ScreenWindow_Metrics ; ; R0=buf, R1=x, R2=y, R3=width,[SP]=height
					BLX		R7
					
					
					ADR		R1, col_fg
					ADD		R2, R1, #4
					ADD     R0, SP, #0x20					
					LDR		R7, ScreenWindow_Color ;
					BLX		R7
					
					
					ADD     R1, SP, #0x10
					ADD     R0, SP, #0x20
					MOV		R2,#0
					MOV		R3,#0
					STR		R3,[SP,#4]
					MOV		R2,#0
					STR		R3,[SP]
					ADR		R3,_mywstring		
					MOV		R2,#0
									
					LDR		R7, ScreenWindow_Text ; R0=buffer, R1=points2 general_metrics,; R2=inversion?, r3=ptr2ws,; SP=font, sp+4=alignement?
					BLX		R7
					
					
					ADD		R0, SP, #0x20
					; ADD     R1, SP, #0x10
					LDR		R7, ScreenWindowPushBuffer
					BLX		R7		
					
					LDR		R0,=0xA8750000
					MOV		R1,#2
					LSL		R1,#8
					LDR		R2,_mytest
					BL		f077_CallAfterTimer
					
					ADD		SP, #0x180	
					POP		{R1-R7,PC}
					
_mytest				DCD		mytest	
__mywstring			DCD	_mywstring				
_mywstring			DCD	mywstring				
mywstring			DCB 05,00,"b",0,"e",0,"n",0,"j",0,"9",0



; ----


